/*
 * memFile.h --
 *
 *      Declarations used by the memFile extension
 *
 * Copyright (c) 1997 Clif Flynt
 *
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a 
 * DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: $Log:
 */

#ifndef _MEMFILEINT
#define _MEMFILEINT

/* 
 * Declare the #includes that will be used by this extension
 */

/* Uncomment this if compiling with C++ compiler */
#include <stdio.h>
#include <malloc.h>

/***
extern "C" {
***/
#include "tcl.h"
/***
}
***/

/* #include <tcl.h>*/
#include <string.h>
  
/*
 * Define the major and minor version numbers.
 * Note: VERSION is defined as a string, not integers.
 *       MAJOR and MINOR are defined as integers.
 */

#define MEMFILE_VERSION	"1.0"
#define MEMFILE_MAJOR_VERSION	1
#define MEMFILE_MINOR_VERSION	0

// Instance data for an open channel.  The compressed memory buffer is unpacked
// into readBuffer.  The other fields allow Tcl to read pieces from the buffer.

typedef struct instanceData {
     int id;			/* An indelible marker, why does close get called for files I didn't open? */
     Tcl_Channel tclReadChannel;
     unsigned char *readBuffer;
     int readLen;		/* How much data is in readBuffer */
     int readOffset;            /* Where does it start */
     int readSize;              /* How much space is there */
     int maxAccept;             /* The first WriteReady return */
} InstanceData;

// A memory image of a file 
typedef struct memFileData {
  char *name;		// Path to file, rooted at the "filesystem" root.
  int dataLen;		// Number of bytes in data.
  unsigned char *data;	// BZ2 Compressed file data.
} memFileData;


/*   
 * VC++ has an alternate entry point called DllMain, so we 
 * need to rename our entry point.
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN
#   if defined(_MSC_VER)
#       define EXPORT(a,b) __declspec(dllexport) a b
#       define DllEntryPoint DllMain
#   else
#       if defined(__BORLANDC__)
#           define EXPORT(a,b) a _export b
#       else
#           define EXPORT(a,b) a b
#       endif
#   endif
#else
#   define EXPORT(a,b) a b
#endif


/*
 * Function Prototypes for the commands that actually do the 
 *   processing.
 * Two macros are used in these prototypes:
 *
 * EXTERN EXPORT is for functions that must interact with the
 *     Microsoft or Borland C++ DLL loader.
 * ANSI_ARGS is defined in tcl.h
 *     ANSI_ARGS returns an empty string for non-ANSI C 
 *     compilers, and returns it's arguments for ANSI C 
 *     compilers.
 */


/***
extern "C" {
***/

EXTERN EXPORT(int,Memfile_AppInit) _ANSI_ARGS_ ((Tcl_Interp *));
EXTERN EXPORT(int,Memfile_Init) _ANSI_ARGS_ ((Tcl_Interp *));
EXTERN EXPORT(int,memFile_open) _ANSI_ARGS_ 
        ((ClientData, Tcl_Interp *, int, Tcl_Obj **));
// EXTERN EXPORT(memFileData**,MemFile_getMemFileData) _ANSI_ARGS_ ((char *, char *));
EXTERN EXPORT(void*, getHashData) _ANSI_ARGS_ ((Tcl_Interp *, char *, Tcl_HashTable *));
EXTERN EXPORT(unsigned char*, memFile_DecompressBuffer) _ANSI_ARGS_ ((
      unsigned char *, int , int *));
EXTERN EXPORT(Tcl_HashEntry*, MemFile_getMemFileData) _ANSI_ARGS_ 
    ((char *, char *));
EXTERN EXPORT(Tcl_Channel, memFile_OpenFileChannel) _ANSI_ARGS_ 
    ((Tcl_Interp *, Tcl_Obj *, int , int ));
EXTERN EXPORT(int, memFile_listFilesCmd) _ANSI_ARGS_ 
    ((ClientData , Tcl_Interp *, int, Tcl_Obj **));
EXTERN EXPORT(int, memFile_MatchCmd) _ANSI_ARGS_ 
    ((ClientData , Tcl_Interp *, int, Tcl_Obj **));
EXTERN EXPORT(int, memFile_MountCmd) _ANSI_ARGS_ 
    ((ClientData , Tcl_Interp *, int, Tcl_Obj **));
EXTERN EXPORT(int, memFile_openCmd) _ANSI_ARGS_ 
    ((ClientData , Tcl_Interp *, int, Tcl_Obj **));

/***
  }
***/

/* 
 * For debuging printf's.
 */

#define debugprt	if (memFileDebugPrint>0) printf


#endif
/* End _CHECKSUMINT */


